using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Data;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmCostAccountingReport
	/// </summary>
	public class FrmCostAccountingReport : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.GroupBox grpImage;
        private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Button btnPrint;
		private System.ComponentModel.IContainer components = null;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvCostAccountingReport;
		private System.Windows.Forms.PrintDialog printDialog1;
        Hashtable _dataSource;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="dataSource"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		public FrmCostAccountingReport(Hashtable dataSource, DateTime startDate, DateTime endDate)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			SetComponentProperties();
            _dataSource = dataSource;
			LoadCostAccountingReport(dataSource, startDate, endDate);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmCostAccountingReport));
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnPrint = new System.Windows.Forms.Button();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            this.rvCostAccountingReport = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.TabIndex = 3;
            this.vbecsLogo1.Title = "Cost Accounting Report";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.TabIndex = 5;
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.BackColor = System.Drawing.SystemColors.Control;
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 410);
            this.grpImage.TabIndex = 4;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 8);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(45, 45);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(564, 448);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 2;
            this.btnCancel.Text = "&Close";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(484, 448);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 1;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            // 
            // rvCostAccountingReport
            // 
            this.rvCostAccountingReport.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvCostAccountingReport.Location = new System.Drawing.Point(59, 37);
            this.rvCostAccountingReport.Name = "rvCostAccountingReport";
            this.rvCostAccountingReport.Size = new System.Drawing.Size(580, 405);
            this.rvCostAccountingReport.TabIndex = 6;
            this.rvCostAccountingReport.RenderingComplete += new Microsoft.Reporting.WinForms.RenderingCompleteEventHandler(this.rvCostAccountingReport_RenderingComplete);
            this.rvCostAccountingReport.RenderingBegin += new System.ComponentModel.CancelEventHandler(this.rvCostAccountingReport_RenderingBegin);
            // 
            // FrmCostAccountingReport
            // 
            this.AcceptButton = this.btnPrint;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(642, 473);
            this.Controls.Add(this.rvCostAccountingReport);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnPrint);
            this.hlphelpChm.SetHelpKeyword(this, "Cost_Accounting_Report.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(600, 450);
            this.Name = "FrmCostAccountingReport";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Cost Accounting Report";
            this.Load += new System.EventHandler(this.FrmCostAccountingReport_Load);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.rvCostAccountingReport, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC075.FrmCostAccountingReport());
            BOL.VbecsReport.SetUpReportButtons(this.rvCostAccountingReport);
        }

		private void LoadCostAccountingReport(Hashtable dataSource, DateTime startDate, DateTime endDate)
		{
           DataSet dsHeader = BOL.VbecsReport.GetReportHeader(ThisUser.UserName);

           string reportCriteria = "Date Range: ";
           reportCriteria += Common.VBECSDateTime.FormatDateString(startDate);
           reportCriteria += " - ";
           reportCriteria += Common.VBECSDateTime.FormatDateString(endDate);
           DataSet dsFooter = BOL.VbecsReport.GetReportFooter(reportCriteria);

           ReportDataSource reportSourceMain = new ReportDataSource();
           if (dataSource[Common.CostAccountingReportSections.Main] != null)
            {
                reportSourceMain.Name = "CostAccountingMainDataSet";
                reportSourceMain.Value = (DataTable)dataSource[Common.CostAccountingReportSections.Main];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.CostAccountingReport.CostAccountingReport.rdlc");
            Stream streamIncomingShipment = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.CostAccountingReport.IncomingShipment.rdlc");
            Stream streamOutgoingShipment = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.CostAccountingReport.OutgoingShipment.rdlc");
            Stream streamUnitModifications = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.CostAccountingReport.UnitModifications.rdlc");
            Stream streamOffSiteABIDs = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.CostAccountingReport.OffSiteABIDs.rdlc");
            Stream streamDiscardedUnits = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.CostAccountingReport.DiscardedUnits.rdlc");
            Stream streamInactivatedUnits = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.CostAccountingReport.InactivatedUnits.rdlc");

            this.rvCostAccountingReport.LocalReport.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);
            
            this.rvCostAccountingReport.LocalReport.DataSources.Add(reportSourceMain);
            this.rvCostAccountingReport.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvCostAccountingReport.LocalReport.DataSources.Add(reportSourceFooter);
            this.rvCostAccountingReport.LocalReport.LoadReportDefinition(stream);
            this.rvCostAccountingReport.LocalReport.LoadSubreportDefinition("IncomingShipment", streamIncomingShipment);
            this.rvCostAccountingReport.LocalReport.LoadSubreportDefinition("OutgoingShipment", streamOutgoingShipment);
            this.rvCostAccountingReport.LocalReport.LoadSubreportDefinition("UnitModifications", streamUnitModifications);
            this.rvCostAccountingReport.LocalReport.LoadSubreportDefinition("OffSiteABIDs", streamOffSiteABIDs);
            this.rvCostAccountingReport.LocalReport.LoadSubreportDefinition("DiscardedUnits", streamDiscardedUnits);
            this.rvCostAccountingReport.LocalReport.LoadSubreportDefinition("InactivatedUnits", streamInactivatedUnits);
            this.rvCostAccountingReport.RefreshReport();
		}

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
            //CR 3449
            try
            {
                this.rvCostAccountingReport.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "IncomingShipment" || e.DataSourceNames[0].ToString() == "IncomingShipmentDataSet")
            {
                ReportDataSource reportSourceIncomingShipment = new ReportDataSource();
                if (_dataSource[Common.CostAccountingReportSections.IncomingShipment] != null)
                {
                    reportSourceIncomingShipment.Name = "IncomingShipmentDataSet";
                    reportSourceIncomingShipment.Value = (DataTable)_dataSource[Common.CostAccountingReportSections.IncomingShipment];
                }
                e.DataSources.Add(reportSourceIncomingShipment);
            }
            else if (e.ReportPath == "OutgoingShipment" || e.DataSourceNames[0].ToString() == "OutgoingShipmentDataSet")
            {
                ReportDataSource reportSourceOutgoingShipment = new ReportDataSource();
                if (_dataSource[Common.CostAccountingReportSections.OutgoingShipment] != null)
                {
                    reportSourceOutgoingShipment.Name = "OutgoingShipmentDataSet";
                    reportSourceOutgoingShipment.Value = (DataTable)_dataSource[Common.CostAccountingReportSections.OutgoingShipment];
                }
                e.DataSources.Add(reportSourceOutgoingShipment);
            }
            else if (e.ReportPath == "UnitModifications" || e.DataSourceNames[0].ToString() == "UnitModificationsDataSet")
            {
                ReportDataSource reportSourceUnitModifications = new ReportDataSource();
                if (_dataSource[Common.CostAccountingReportSections.Modifications] != null)
                {
                    reportSourceUnitModifications.Name = "UnitModificationsDataSet";
                    reportSourceUnitModifications.Value = (DataTable)_dataSource[Common.CostAccountingReportSections.Modifications];
                }
                e.DataSources.Add(reportSourceUnitModifications);
            }
            else if (e.ReportPath == "OffSiteABIDs" || e.DataSourceNames[0].ToString() == "OffSiteABIDsDataSet")
            {
                ReportDataSource reportSourceOffSiteABIDs = new ReportDataSource();
                if (_dataSource[Common.CostAccountingReportSections.OffSiteABID] != null)
                {
                    reportSourceOffSiteABIDs.Name = "OffSiteABIDsDataSet";
                    reportSourceOffSiteABIDs.Value = (DataTable)_dataSource[Common.CostAccountingReportSections.OffSiteABID];
                }
                e.DataSources.Add(reportSourceOffSiteABIDs);
            }
            else if (e.ReportPath == "DiscardedUnits" || e.DataSourceNames[0].ToString() == "DiscardedUnitsDataSet")
            {
                ReportDataSource reportSourceDiscardedUnits = new ReportDataSource();
                if (_dataSource[Common.CostAccountingReportSections.DiscardedUnits] != null)
                {
                    reportSourceDiscardedUnits.Name = "DiscardedUnitsDataSet";
                    reportSourceDiscardedUnits.Value = (DataTable)_dataSource[Common.CostAccountingReportSections.DiscardedUnits];
                }
                e.DataSources.Add(reportSourceDiscardedUnits);
            }
            else if (e.ReportPath == "InactivatedUnits" || e.DataSourceNames[0].ToString() == "InactivatedUnitsDataSet")
            {
                ReportDataSource reportSourceInactivatedUnits = new ReportDataSource();
                if (_dataSource[Common.CostAccountingReportSections.InactivatedUnits] != null)
                {
                    reportSourceInactivatedUnits.Name = "InactivatedUnitsDataSet";
                    reportSourceInactivatedUnits.Value = (DataTable)_dataSource[Common.CostAccountingReportSections.InactivatedUnits];
                }
                e.DataSources.Add(reportSourceInactivatedUnits);
            }
        }

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

        private void FrmCostAccountingReport_Load(object sender, EventArgs e)
        {

            this.rvCostAccountingReport.RefreshReport();
        }

        /// <summary>
        /// CR 3581
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void rvCostAccountingReport_RenderingBegin(object sender, CancelEventArgs e)
        {
            this.btnPrint.Enabled = false;
        }

        /// <summary>
        /// CR 3581
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void rvCostAccountingReport_RenderingComplete(object sender, RenderingCompleteEventArgs e)
        {
            this.btnPrint.Enabled = true;
        }
	}
}

